import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample08_Lunch2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .styleInternationalCharacter(
              StarXpandCommand.Printer.InternationalCharacterType.Japan,
            )
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter("logo_01.png", 400),
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
            .actionPrintText("${number}\n" + "会計日:${account_day}\n")
            .actionFeed(3.0)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("領 収 書\n"),
            )
            .actionFeed(3.0)
            .styleUnderLine(true)
            .actionPrintText(
              "${customer_name}",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                15,
                new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                  StarXpandCommand.Printer.TextWidthType.Full,
                ),
              ),
            )
            .actionPrintText("様\n")
            .styleUnderLine(false)
            .actionFeedLine(2)
            .actionPrintText("領収金額\n")
            .actionPrintText("        ")
            .styleBold(true)
            .styleUnderLine(true)
            .actionPrintText(
              "\\${total_price}-\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(false)
            .styleUnderLine(false)
            .actionPrintText("     (10%標準対象")
            .actionPrintText(
              "\\${tax_rate_10_target})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                15,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("     ( 内消費税等")
            .actionPrintText(
              "\\${tax_rate_10_tax})\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                15,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionFeedLine(1)
            .actionPrintText("上記正に領収いたしました\n")
            .actionFeedLine(2)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .styleUnderLine(true)
            .actionPrintText("但 ")
            .actionPrintText(
              "${description}",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                11,
                new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                  StarXpandCommand.Printer.TextWidthType.Full,
                ),
              ),
            )
            .actionPrintText(" として")
            .actionFeedLine(3)
            .styleUnderLine(false)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${store_name}\n"),
            )
            .actionPrintText(
              "${address}\n" +
                "TEL:${telephone_number}\n" +
                "登録番号:${registration_number}\n" +
                "\n" +
                "担当者:${staff_name}\n" +
                "領収書No:\n" +
                "${receipt_number}\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "number" : "0001-0001",
    "account_day" : "2022/01/01",
    "customer_name" : "静岡 太郎",
    "total_price" : 1500,
    "tax_rate_10_target" : 1500,
    "tax_rate_10_tax" : 136,
    "description" : "ご飲食代",
    "store_name" : "Starカフェ 丸の内店",
    "address" : "東京都千代田区\\n○○１丁目２－３",
    "telephone_number" : "01-2345-6789",
    "registration_number" : "T1234567890123",
    "staff_name" : "静岡 花子",
    "receipt_number" : "000120160510111212345"
}`,
    );
  }
}
